#include "REG_MG84FL54.H"
#include "Define.H"
#include "UART.H"


extern BYTE OutLen;
extern XBYTE OutBuffer[UART_MAX];

extern UART Uart;


void INT_UART(void) interrupt 4 using 2          // Uart INT
  { if ( RI )
      { OutBuffer[Uart.In_Addr] = SBUF;
      	RI = CLR;
      	Uart.In_Addr++;
      	Uart.Data_Cnt++;
      	if ( Uart.In_Addr == UART_MAX )          // Top of " OutBuffer "
      	  Uart.In_Addr = 0;                      // Reset " In_Addr " from 0
      }
    if ( TI )
      { TI = CLR;
        Uart.Tx_Busy = CLR;
      }
  }